<?php

Mock::generate('Wact_View_Scoped', 'MockWact_View_Scoped');

abstract class Wact_View_Scoped_Test extends Wact_View_Partial_Test {

    // Override parent test
    function testAppendChild() {
        $dataParent = new Wact_View_Partial();

        $child = new Wact_View_Partial();
        $this->view->appendChild($child, 'child');

        $this->assertReference($child->parent, $this->view);
    }

    function testBindScope() {
        $root = new Wact_View_Partial();

        $child = new MockWact_View_Partial($this);
        $child->expectOnce('bindScope');

        // Causes recursive error in simpletest
        // $child->expectOnce('bindScope', array($root, $this->view));

        $this->view->appendChild($child);

        $this->view->bindScope($root, $root);

        $this->assertReference($this->view->root, $root);

        $child->tally();
    }

    // Override parent test
    function testDataProperty() {
        $root = new Wact_View_Root();
        $root->appendChild($this->view);
        
        $root->bindScope($root, $root);

        $this->assertReference($this->view->myScope, $this->view);
    }

}

?>