<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* A Wact_View_Root forms the root of a tree of view components.
*/
class Wact_View_Root extends Wact_View_Scoped {

    /**
    * Character encoding for this view
    * @var string encoding
    */
    public $charset = 'utf-8';

    /**
    * Output Buffer
    * @var string encoding
    */
    public $output;

    /**
    * Output this view
    * If an exception occurs during rendering, there is no output.
    * @throws Wact_View_Exception_Rendering
    */
    function display() {
        try {
            $this->bindScope($this, $this);
        } catch (Exception $e) {
            throw new Wact_View_Exception_Rendering('View could not be rendered', $e);
        }
        
        if (empty($this->output)) {
            // Switch to DI
            $this->output = new Wact_Response_Buffer();
        }
        $this->output->start();

        try {
            $this->render();
            $this->output->end();
        } catch (Exception $e) {
            $this->output->clean();
            throw new Wact_View_Exception_Rendering('View could not be rendered', $e);
        }
            
    }

    /**
    * Return the output from this view as a string
    * @throws Wact_View_Exception_Rendering
    */
    function capture() {
        try {
            $this->bindScope($this, $this);
        } catch (Exception $e) {
            throw new Wact_View_Exception_Rendering('View could not be rendered', $e);
        }

        if (empty($this->output)) {
            // Switch to DI
            $this->output = new Wact_Response_Buffer();
        }
        $this->output->start();

        try {
            $this->render();
            return $this->output->get();
        } catch (Exception $e) {
            $this->output->clean();
            throw new Wact_View_Exception_Rendering('View could not be rendered', $e);
        }
    }
    
}

?>