<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

// Must have lazy loading of Form Transition to allow subclasses to avoid
// the overhead when not necessary.  (Such as in a compiled template.)

/**
* Base class for View components that output XML/HTML tags
*/
class Wact_View_Form extends Wact_View_Tag {

    protected $transition;

    function __construct($attributes = array()) {
        parent::__construct('form', $attributes);
    }

    /**
    * Set the attribute values as needed.
    */
    function paintOpen() {
        $this->setAttribute('action', $this->getTransition()->getHREF());
        parent::paintOpen();
    }
    
    /**
    * Outputs hidden fields containing extra state from the form
    */
    function paintClose() {
        $state = $this->getTransition()->getRemainingState();
        foreach($state as $name => $value) {
            echo '<input type="hidden" name="' . $name . '" value="' . htmlspecialchars($value, ENT_QUOTES) . '" ';
            if (!$this->isClosingTagRequired) {
                echo '/';
            }
            echo '>';
        }
        parent::paintClose();
    }

    /**
    */
    function getTransition() {
        if (empty($this->transition)) {
            $this->transition = new Wact_Controller_Transition_Form(
                $this->controller, $this->controller->getCommand(), $this->rootScope->model);
            $this->transition->build();
        }
        return $this->transition;
    }
}

?>