<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Show the view components
*/
class Wact_View_Debugger {

    /**
    * Show the view information in html format.
    */
    function printView($view) {
        echo '<div>';
        $name = $view->getViewId();
        if (empty($name)) {
            $name = '(top level)';
        }

        echo '<b>' . $name .  '</b> :: ';
        echo get_class($view);
        echo ' (' . get_parent_class($view) . ')';
        echo '<br />';

        if (isset($view->controller)) {
            echo 'controller: ' . get_class($view->controller) . '<br />';
        }
        if (isset($view->myScope->model)) {
            echo 'model:';
            var_dump($view->myScope->model);
            echo '<br />';
        }
        if (count($view->children) > 0) {
            echo '<ul>';
            foreach ($view->children as $child) {
                echo '<li>';
                self::printView($child);
                echo '</li>';
            }
            echo '</ul>';
        }
        echo '<div>';
    }

    /**
    * Show the view information in html format.
    */
    static function dump($view) {
        echo "<h3>View Dump:</h3>";
        self::printView($view);
    }

}
?>