<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Command to print help about other commands.
*/
class Wact_Cli_Command_help extends Wact_Tool_Cli_Command {

    /**
    */
    public $name = 'help';
    
    /**
    */
    public $description = "Displays a list of available commands.\n";
    
    /**
    * Execute this command.
    */
    public function run($argv = array(), $dispatcher = NULL, $project = NULL) {
        $options = $this->options->parse($argv);

        $args = $options[1];
        if (count($args) == 0) {
            echo "\nUsage: wact [options] command [command-options] <parameters>\n";
            echo "\nCommands:\n";
            
            foreach($dispatcher->getCommands() as $subject) {
                $command = $dispatcher->findCommand($subject);
                echo str_pad($command->name, 15) . ' ' . $command->description;
            }
    
            echo "\n";
        } else if (count($args) != 1) {
            echo "too many arguments.\n";
        } else {
            $subject = $args[0];
            $command = $dispatcher->findCommand($subject);
            if (is_object($command)) {
                $command->printUsage($project);
            } else if ($subject == 'wact') {
                $dispatcher->printUsage($project);
            } else {
                echo "There is no help available for '$subject'.\n";
            }
        }
    }

    /**
    * Print detailed help information about this command.
    */
    public function printUsage($project) {
        echo "\nUsage: wact help [subject]\n";
        echo "\n";
        echo "Retreives detailed help about a particular wact command.\n\n";
        $this->options->printOptions();
        echo "\n";
    }
    
}

?>