<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Describes a command line option
*/
class Wact_Tool_Cli_Option {

    /**
    * Internal name for this command line option
    */
    public $name;

    /**
    * Description of this option
    */
    public $description;

    /**
    * Getopt long format string describing this option.  This is the long
    * option name, follwed by = for options that take parameters or == for
    * options with optional parameters.
    */
    public $long = NULL;

    /**
    * Getopt short format string describing this option.  This a single letter
    * follwed by : for options that take parameters or :: for
    * options with optional parameters.
    */
    public $short = NULL;
    
    /**
    *
    */
    function __construct($name, $description, $long = NULL, $short = NULL) {
        $this->name = $name;
        $this->description = $description;
        $this->long = $long;
        $this->short = $short;
    }
    
    /**
    * Print a term and its description in two columns with wordwrapping.
    */
    protected function printTwoColumns($term, $description, $termSize, $descSize) {
        echo str_pad($term, $termSize), 
            str_replace("\n", "\n" . str_repeat(' ', $termSize),
            wordwrap($description, $descSize)),
            "\n";
    }
    
    /**
    * Print a description of this option
    */
    function printDescription($size, $maxColumns) {
        $long = NULL;
        if (isset($this->long)) {
            $long = trim($this->long, '=');
            $this->printTwoColumns(
                '--' . $long, $this->description, 
                $size + 3, $maxColumns - $size - 3);
        }
        if (isset($this->short)) {
            $short = trim($this->short, ':');
            if (isset($long)) {
                $description = "Shortcut for --$long";
            } else {
                $description = $this->description;
            }
            $this->printTwoColumns(
                ' -' . $short, $description, 
                $size + 3, $maxColumns - $size - 3);
        }
    }
}

?>