<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class Wact_Test_Reporter_Html extends HtmlReporter {

    var $userInterface;
    var $startTime;
    var $stopTime;
    
    /**
    */
    function setInterface($ui) {
        $this->userInterface = $ui;
    }

    /**
    */
    function startTiming() {
        $this->startTime = microtime();
    }
    
    /**
    */
    function stopTiming() {
        $this->stopTime = microtime();
    }
    
    /**
    */
    function getElapsedTime() {
        return number_format(((substr($this->stopTime, 0, 9)) +
            (substr($this->stopTime,-10)) - 
            (substr($this->startTime, 0, 9)) - 
            (substr($this->startTime, -10))), 4);
    }

    /**
    */
    function paintTitle($test_name) {
        echo "<h1>$test_name</h1>\n";
    }

    /**
    */
    function paintHeader($test_name) {
        $this->startTiming();
        $this->sendNoCacheHeaders();
        $this->userInterface->printHeader();
        $this->paintTitle($test_name);
        flush();
    }

    /**
    */
    function paintTestRunSummary($test_name) {
        $this->stopTiming();
        $colour = ($this->getFailCount() + $this->getExceptionCount() > 0 ? "red" : "green");
        echo "<div style=\"";
        echo "padding: 8px; margin-top: 1em; background-color: $colour; color: white;";
        echo "\">";
        echo $this->getTestCaseProgress() . "/" . $this->getTestCaseCount();
        echo " test cases complete:\n";
        echo "<strong>" . $this->getPassCount() . "</strong> passes, ";
        echo "<strong>" . $this->getFailCount() . "</strong> fails and ";
        echo "<strong>" . $this->getExceptionCount() . "</strong> exceptions ";
        echo " (in " . $this->getElapsedTime() . " seconds)";
        echo ".";
        echo "</div>\n";
    }

    /**
    */
    function paintFooter($test_name) {
        $this->paintTestRunSummary($test_name);
        $this->userInterface->printFooter();
    }

}

?>