<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
 * Xml Coverage Reporter
 */
class Wact_Test_Coverage_Reporter_Xml {
    /**
     * Renders the coverage report
     * @param $report Report data
     */
    public function render($report) {
        header('Content-Type: text/xml; charset=iso-8859-1');
        echo '<?xml version="1.0" encoding="iso-8859-1" ?>' . "\n";
        
        echo '<coverage>' . "\n";
        foreach ($report as $filename => $stats) {
            echo '    <file';
            echo ' name="' . htmlentities($filename) . '"';
            echo ' executable="' . $stats[Wact_Test_Coverage_Recorder::EXECUTABLE_LINES] . '"';
            echo ' covered="' . $stats[Wact_Test_Coverage_Recorder::COVERED_LINES] . '"';
            echo ' uncovered="' . $stats[Wact_Test_Coverage_Recorder::UNCOVERED_LINES] . '"';
            echo ' dead="' . $stats[Wact_Test_Coverage_Recorder::DEAD_LINES] . '"';
            echo ' />' . "\n";
        }
        echo '</coverage>' . "\n";
    }
}

?>