<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

abstract class Wact_Test_Case_Template extends Wact_Test_Case {

    function setUp() {
        $this->reader = new Wact_Template_Reader_Transient();
        $this->cache = new Wact_Cache_Store_Transient();
        $this->loader = new Wact_Template_Loader($this->reader, $this->cache);
    }

    function createTempTemplate($source) {

        $resourceName = uniqid('resource_') . '.tpl.html';
        $this->reader->writeSource($resourceName, $source);
        $template = $this->loader->load($resourceName);
        return $template;

    }

}
?>