<?php

class Wact_Template_Tag_wact_wrapTestCase extends Wact_Test_Case {

    function setUp() {
        $this->reader = new Wact_Template_Reader_Transient();
        $this->cache = new Wact_Cache_Store_Transient();
        $this->loader = new Wact_Template_Loader($this->reader, $this->cache);

        $source = '<B><wact:placeholder id="boldarea"></B>';
        $this->reader->writeSource('boldplacewrapper.tpl.html', $source);

        $source = '<I><wact:placeholder id="italicarea"></I>';
        $this->reader->writeSource('italicplacewrapper.tpl.html', $source);
    }

    function testPlaceholderWrap() {
        $source = '<wact:wrap file="boldplacewrapper.tpl.html" insertat="boldarea">Hello</wact:wrap>';
        $this->reader->writeSource('placeholderwrap.tpl.html', $source);

        $tmpl = $this->loader->load('placeholderwrap.tpl.html');
        $output = $tmpl->capture();
        $this->assertEqual($output, '<B>Hello</B>');
    }

    function testMissingFileAttribute() {
        $source = '<wact:wrap></wact:wrap>';
        $this->reader->writeSource('wrap.tpl.html', $source);

        try {
            $tmpl = $this->loader->load('wrap.tpl.html');
            $this->fail('Expected exception not thrown');
        } catch (Wact_Template_Compiler_Exception_Missingattribute $e) {
            $this->pass();
            $this->assertEqual($e->getAttribute(), 'file');
        }
    }

    function testTemplateNotFound() {
        $source = '<wact:wrap file="wrap2.tpl.html"></wact:wrap>';
        $this->reader->writeSource('wrap.tpl.html', $source);

        try {
            $tmpl = $this->loader->load('wrap.tpl.html');
            $this->fail('Expected exception not thrown');
        } catch (Wact_Template_Exception_Notfound $e) {
            $this->pass();
            $this->assertEqual($e->getResourceId(), 'wrap2.tpl.html');
        }
    }

    function testTemplateReadError() {
        $source = '';
        $this->reader->writeSource('wrap.tpl.html', $source);

        try {
            $tmpl = $this->loader->load('wrap.tpl.html');
            $this->fail('Expected exception not thrown');
        } catch (Wact_Template_Compiler_Exception $e) {
            $this->pass();
            $this->assertEqual($e->getResourceId(), 'wrap.tpl.html');
        }
    }

    function testDifferentPlaceholderWraptwice() {
        $source =
            '<wact:wrap file="boldplacewrapper.tpl.html" insertat="boldarea">' .
            '<wact:wrap file="italicplacewrapper.tpl.html" insertat="italicarea">' .
            'Hello</wact:wrap></wact:wrap>';
        $this->reader->writeSource('diffplaceholderwrap.tpl.html', $source);

        $tmpl = $this->loader->load('diffplaceholderwrap.tpl.html');
        $output = $tmpl->capture();
        $this->assertEqual($output, '<B><I>Hello</I></B>');
    }

    function testDifferentPlaceholderWrapDifferent() {
        $source =
            '<wact:wrap file="boldplacewrapper.tpl.html" insertat="boldarea">' .
            'First' .
            '</wact:wrap>' .
            '-' .
            '<wact:wrap file="italicplacewrapper.tpl.html" insertat="italicarea">' .
            'Second' .
            '</wact:wrap>';
        $this->reader->writeSource('diffplaceholderwrapdiff.tpl.html', $source);

        $tmpl = $this->loader->load('diffplaceholderwrapdiff.tpl.html');
        $output = $tmpl->capture();
        $this->assertEqual($output, '<B>First</B>-<I>Second</I>');

    }

    // What if the specified placeholder does not exist?
    // What if no placeholder exists?
    // What if no placeholder attribute is not specified?
    // What happens if the placeholder is not a direct child of the wrap component?

}
?>