<?php

class Wact_Template_Tag_wact_scopeTestCase extends Wact_Test_Case_Template {

    function testScope() {
        $t = $this->createTempTemplate(
            '<wact:scope id="middle">' .
            '{$x}:{$^x}:{$#x}' .
            '</wact:scope>');

        $t->setModel(array('x' => 'outer'));
        $t->setChildModel('middle', array('x' => 'middle'));

        $output = $t->capture();

        $this->assertEqual($output, 'middle:outer:outer');        

    }

    function testNestedScope() {
        $t = $this->createTempTemplate(
            '{$x}:{$^x}:{$#x}' .
            '<wact:scope id="middle">' .
            '-{$x}:{$^x}:{$#x}' .
            '<wact:scope id="inner">' . 
            '-{$x}:{$^x}:{$#x}' .
            '</wact:scope>' .
            '</wact:scope>');

        $t->setModel(array('x' => 'outer'));
        $t->setChildModel('middle', array('x' => 'middle'));
        $t->setChildModel('inner', array('x' => 'inner'));

        $output = $t->capture();

        $this->assertEqual($output, 'outer:outer:outer-middle:outer:outer-inner:middle:outer');        

    }

    function testChildScope() {
        $t = $this->createTempTemplate(
            '<wact:scope from="middle">' .
            '{$x}:{$^x}:{$#x}' .
            '</wact:scope>');

        $t->setModel(array('x' => 'outer', 'middle' => array('x' => 'middle')));
        
        $output = $t->capture();

        $this->assertEqual($output, 'middle:outer:outer');        

    }

    function testChildScopeUnusualId() {
        $t = $this->createTempTemplate(
            '<wact:scope from="1">' .
            '{$x}:{$^x}:{$#x}' .
            '</wact:scope>');

        $t->setModel(array('x' => 'outer', '1' => array('x' => 'middle')));
        
        $output = $t->capture();

        $this->assertEqual($output, 'middle:outer:outer');        

    }

    function testScopeFromList() {
        $t = $this->createTempTemplate(
            '<wact:scope from=\'{$["name"=>"foo"]}\'>{$name}</wact:scope>');

        $output = $t->capture();

        $this->assertEqual($output, 'foo');
    }

}
?>