<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* @tag wact:link
* @attributes command parameters
*/
class Wact_Template_Tag_wact_link extends Wact_Template_Compiler_Node_TagView {

    /**
    * The view class corresponding to this template node.
    * @var string
    */
    public $parentViewClass = 'Wact_View_Tag';

    /**
    * Generate the code to initialize the view based on this tag.
    * @param Wact_Php_Writer $code
    */
    function generateConstructParameters($code) {
        $code->writePHP('"a", ');
        $code->writePHP(var_export($this->getAttributesAsArray($this->getAttributeFilter()), TRUE));
        $code->writePHP(', ');
        $code->writePHP(var_export($this->closing == self::CLOSING_TAG, TRUE));
    }

    /**
    */
    function generatePaintExtraAttributes($code) {
        parent::generatePaintExtraAttributes($code);
        if ($this->hasAttribute('command')) {
            $varRef = '$' . $code->createTempVariable();

            if ($this->hasAttribute('parameters')) {
                $this->attributeNodes['parameters']->generatePreStatement($code);
            }

            $code->writePHP($varRef . ' = new Wact_Controller_Transition_Link(');
            $code->writePHP('$this->controller, ');
            $this->attributeNodes['command']->generateExpression($code);
            $code->writePHP(', $this->rootScope->model');
            if ($this->hasAttribute('parameters')) {
                $code->writePHP(', (array)');
                $this->attributeNodes['parameters']->generateExpression($code);
            }
            $code->writePHP(');');
            if ($this->hasAttribute('parameters')) {
                $this->attributeNodes['parameters']->generatePostStatement($code);
            }
            $code->writePHP($varRef . '->build();');

            $code->writeHTML(' href="');
            $code->writePHP('echo ' . $varRef . '->getHREF();');
            $code->writeHTML('"');

        }
    }

}
?>