<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Include another template into the current template
* @tag wact:INCLUDE
* @attributes file literal
* @end_tag ENDTAG_FORBIDDEN
*/
class Wact_Template_Tag_wact_include extends Wact_Template_Compiler_Node_Inline {

    /**
    * @param Wact_Template_Compiler_Parser_TreeBuilder $treeBuilder
    * @return int Wact_Template_Compiler_Node::FORBID_PARSING
    */
    public function preParse($treeBuilder) {
        $file = $this->getAttributeValue('file');
        if (empty($file)) {
            throw new Wact_Template_Compiler_Exception_MissingAttribute(
                'file', $this->getTag(), $this->sourceLocation->file, $this->sourceLocation->line);
        }

        $data = $treeBuilder->getCompilingContext()->readSource($file);
        if (!$data) {
            throw new Wact_Template_Compiler_Exception('Cannot read resource "{ResourceId}"', $file);
        }

        if ($this->getBoolAttributeValue('literal')) {
            $literalComponent = new Wact_Template_Compiler_Node_Text(null, null, $this->sourceLocation, $data);
            $this->addChild($literalComponent);
        } else {
            $treeBuilder->parseSource($data, $this, $file);
        }

        return parent::FORBID_PARSING;
    }
}
?>