<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Compile time component for block tags
* @tag input
* @location LOCATION_CLIENT
* @known_parent Wact_Template_Tag_form
* @end_tag ENDTAG_FORBIDDEN
*/
class Wact_Template_Tag_input extends Wact_Template_Compiler_Node_TagView {

    // We should probably prevent this tag from having any children

    /**
    * The view class corresponding to this template node.
    * @var string
    */
    public $parentViewClass = 'Wact_View_Form_Element';

    /**
    * Sets the viewClass property, depending on the type of
    * Input tag
    * @return void
    */
    function prepare() {
        $type = strtolower($this->getAttributeValue('type'));
        switch ($type) {
        case 'text':
            $this->parentViewClass = 'Wact_View_Form_Text';
            break;
        case 'password':
            $this->parentViewClass = 'Wact_View_Form_Text';
            break;
        case 'checkbox':
            $this->parentViewClass = 'Wact_View_Form_Checkable';
            break;
        case 'submit':
            break;
        case 'radio':
            $this->parentViewClass = 'Wact_View_Form_Checkable';
            break;
        case 'reset':
            break;
        case 'file':
            break;
        case 'hidden':
            break;
        case 'image':
            break;
        case 'button':
            break;
        default:
            throw new Wact_Template_Compiler_Exception('Unknown value for type attribute "{Type}"', $type);
        }
        
        parent::prepare();
    }

    /**
    * Generate the code to initialize the view based on this tag.
    * @param Wact_Php_Writer $code
    */
    function generateConstructParameters($code) {
        if ($this->parentViewClass == 'Wact_View_Form_Element') {
            $code->writePHP(var_export($this->getRenderedTag(), TRUE) . ',');
        }
        parent::generateConstructParameters($code);
    }

}
?>