<?php

class Attributes_TestCase extends Wact_Test_Case_Template {

    function testTextAttribute() {
        $template = '<P ALIGN="CENTER"></P>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testJavaScriptAttribute() {
        $template = '<P onmouseover="window.status=\'Test\'; return true">contents</P>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testWactAttribute() {
        $tmpl = $this->createTempTemplate('<div wact:id="test">contents</div>');

        $tag = $tmpl->getChild('test');
        $tag->setAttribute('extra', 'Foo');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="Foo">contents</div>');
    }

    function testWactMinimizedAttribute() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra>contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra>contents</div>');
    }

    function testJavaScriptWactAttribute() {
        $template = '<P wact:id="test" onmouseover="window.status=\'Test\'; return true">contents</P>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, '<P onmouseover="window.status=\'Test\'; return true">contents</P>');
    }

    function testWactAttributeVariable() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="{$Var}">contents</div>');

        $tmpl->setModel(array('Var' => 'Foo'));

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="Foo">contents</div>');
    }

    function testWactCompoundAttributeVariable() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="bar{$Var}bar" extra2="{$Var}bar{$Var}">contents</div>');

        $tmpl->setModel(array('Var' => 'Foo'));

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="barFoobar" extra2="FoobarFoo">contents</div>');
    }

    function testWactAttributeVariableFilter() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="{$Var|uppercase}">contents</div>');

        $tmpl->setModel(array('Var' => 'Foo'));

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="FOO">contents</div>');
    }

    function testWactAttributeEscape() {
        $tmpl = $this->createTempTemplate('<div wact:id="test">contents</div>');

        $tag = $tmpl->getChild('test');
        $tag->setAttribute('extra', '&"\'<>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="&amp;&quot;&#039;&lt;&gt;">contents</div>');
    }

    function testWactAttributeVariableEscape() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="{$Var}">contents</div>');

        $tmpl->setModel(array('Var' => '&"\'<>'));

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="&amp;&quot;&#039;&lt;&gt;">contents</div>');
    }

    function testWactAttributeEntityPassThrough() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="&quot;">contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="&quot;">contents</div>');
    }

    function testWactAttributeLtPassThrough() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="<">contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="<">contents</div>');
    }

    function testWactAttributeGtPassThrough() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra=">">contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra=">">contents</div>');
    }

    function testWactAttributeAmpPassThrough() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="&">contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="&">contents</div>');
    }

    function testWactAttributeQuotPassThrough() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra=\'"\'>contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra=""">contents</div>');
        // May not be a desirable feature
    }

    function testWactAttributeSingleQuotPassThrough() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="\'">contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="\'">contents</div>');
    }

    function testWactAttributeExpressionEntityEscaped() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra3="{$\'&quot;\'}">contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra3="&amp;quot;">contents</div>');
    }

    function testWactAttributeExpressionLtEscaped() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="{$\'<\'}">contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="&lt;">contents</div>');
    }

    function testWactAttributeExpressionGtEscaped() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="{$\'>\'}">contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="&gt;">contents</div>');
    }

    function testWactAttributeExpressionAmpEscaped() {
        $tmpl = $this->createTempTemplate('<div wact:id="test" extra="{$\'&\'}">contents</div>');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="&amp;">contents</div>');
    }

    function testWactAttributeVariableId() {
        $this->expectException();
        $tmpl = $this->createTempTemplate('<div wact:id="{$var}">contents</div>');

        $tag = $tmpl->getChild('test');
        $tag->setAttribute('extra', 'Foo');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="Foo">contents</div>');
    }

    function testWactAttributeVariableIdSelfClose() {
        $this->expectException();
        $tmpl = $this->createTempTemplate('<br wact:id="{$var}" />');

        $tag = $tmpl->getChild('test');
        $tag->setAttribute('extra', 'Foo');

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="Foo">contents</div>');
    }

}
?>
