<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Handler for the literal parsing state
*/
class Wact_Template_Compiler_Parser_State_Literal extends Wact_Template_Compiler_Parser_State {
    /**
    * Name of the literal tag
    * @var string
    */
    private $literalTag;

    /**
    */
    function activate($tag) {
        $this->literalTag = $tag;
    }

    /**
    * Handle opening tags
    * @param string tag name
    * @param array tag attributes
    */
    function startElement($tag, $attrs) {
        $this->treeBuilder->addTextNode($this->locator->getRawEventString());
    }

    /**
    * Handle closing tags
    * @param string tag name
    * @param boolean empty tag or not
    */
    function endElement($tag) {
        if ( $this->literalTag == $tag ) {
            $this->treeBuilder->popTag($tag);
            $this->parser->changeToComponentParsingState();
        } else {
            $this->treeBuilder->addTextNode($this->locator->getRawEventString());
        }
    }

    /**
    * Handle empty tags
    * @param string tag name
    * @param array tag attributes
    */
    function emptyElement($tag, $attrs) {
        $this->treeBuilder->addTextNode($this->locator->getRawEventString());
    }

    /**
    * Handle tag content
    * @param string tag content
    */
    function characters($text) {
        $this->treeBuilder->addTextNode($text);
    }

    /**
    * Handle cdata section
    * @param string content of comment
    */
    function cdata($text) {
        $this->treeBuilder->addTextNode($this->locator->getRawEventString());
    }

    /**
    * Handle XML comments
    * @param string content of comment
    */
    function comment($text) {
        $this->treeBuilder->addTextNode($this->locator->getRawEventString());
    }

}
?>