<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*
*/
class Wact_Template_Compiler_Parser_AttributeListener implements Wact_Template_Compiler_Expression_Observer {

    protected $component;
    protected $name;
    protected $compound;

    function __construct($component, $name) {
        $this->component = $component;
        $this->name = $name;
    }

    function addExpression(Wact_Template_Compiler_Expression_Node $expr) {
        $attribute = new Wact_Template_Compiler_Attribute_Expression($this->name, $expr);
        $this->component->addChildAttribute($attribute);
    }

    function addLiteral($text) {
        $attribute = new Wact_Template_Compiler_Attribute($this->name, $text);
        $this->component->addChildAttribute($attribute);
    }

    function beginFragments() {
        $this->compound = new Wact_Template_Compiler_Attribute_Compound($this->name);
    }

    function addLiteralFragment($text) {
        $attribute = new Wact_Template_Compiler_Attribute_Fragment_Literal($text);
        $this->compound->addAttributeFragment($attribute);
    }

    function addExpressionFragment(Wact_Template_Compiler_Expression_Node $expr) {
        $attribute = new Wact_Template_Compiler_Attribute_Fragment_Expression($expr);
        $this->compound->addAttributeFragment($attribute);
    }

    function endFragments() {
        $this->component->addChildAttribute($this->compound);
    }

}

?>
