<?php

/**
* Make partial mock to control behaviour of getViewId which has static counter
*/
Mock::generate('Wact_Template_Compiler_Node', 'MockTemplateNode');
Mock::generatePartial('Wact_Template_Compiler_Node_View','Wact_Template_Compiler_Node_ViewTestVersion', array('getViewId'));
//Mock::generatePartial('WactOldCodeWriter','CodeWriterTestVersion', array('registerInclude'));

class Wact_Template_Compiler_Node_ViewTestCase extends Wact_Test_Case {

    function setUp() {
        $this->node = new Wact_Template_Compiler_Node_ViewTestVersion($this);
        $this->node->setReturnValue('getViewId', 'id001');
    }

    function tearDown() {
        unset ( $this->node );
        parent::tearDown();
    }

    function testGetViewIdFromId() {
        $this->assertEqual($this->node->getViewId(), 'id001');
    }
    
    function testGetViewIdFromWactId() {
        $this->assertEqual($this->node->getViewId(), 'id001');
    }

    function testGetViewIdAttribute() {
        $this->assertEqual($this->node->getViewId(), 'id001');
    }

/*
    function testGenerateConstructor() {
        // BAD TEST: see bug #896626
        // HF - small improvement but violating CodeWriter API
        $this->node->parentViewClass = 'testname';

        $code = new CodeWriterTestVersion($this);
        $code->expectOnce('registerInclude', array('testinclude.inc.php'));

        $this->node->generateConstructor($code);
        $this->assertEqual($code->getCode(), '<?php $this->addChild(new testname(), \'id001\'); ?>');
    }
*/

    function testGetViewIdNew() {
    }

    function testGetViewIdNewAgain() {
    }
}
?>
