<?php

class WactGenericTagTestCase extends Wact_Test_Case {

    function setUp() {
        $this->reader = new Wact_Template_Reader_Transient();
        $this->cache = new Wact_Cache_Store_Transient();
        $this->loader = new Wact_Template_Loader($this->reader, $this->cache);
    }

    function testGenericTag() {
        $source = '<Img ID="runtime" wact:id="*">';

        $this->reader->writeSource('/tags/generictag1.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag1.tpl.html');

        $view = $tmpl->getChild('runtime');

        $this->assertTrue($view instanceof Wact_View_Tag);

        $view->setAttribute("Src", "Img.gif");

        $output = $tmpl->capture();
        $this->assertEqual($output, '<Img ID="runtime" Src="Img.gif"/>');

    }

    function testGenericContainerTag() {
        $source = '<DIV ID="runtime" wact:id="*">Testing<br />Testing</DIV>';

        $this->reader->writeSource('/tags/generictag2.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag2.tpl.html');

        $view = $tmpl->getChild('runtime');

        $view->setAttribute("Align", "center");

        $output = $tmpl->capture();
        $this->assertEqual($output, '<DIV ID="runtime" Align="center">Testing<br />Testing</DIV>');

    }

    function testGenericContainerTagNesting() {
        $source = '<DIV ID="runtime" wact:id="*"><DIV></DIV></DIV>';

        $this->reader->writeSource('/tags/generictag3.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag3.tpl.html');

        $view = $tmpl->getChild('runtime');

        $view->setAttribute("Align", "center");

        $output = $tmpl->capture();
        $this->assertEqual($output, '<DIV ID="runtime" Align="center"><DIV></DIV></DIV>');

    }

    function testGenericContainerTagNestingCaseInsensitive() {
        $source = '<DIV ID="runtime" wact:id="*"><DIV></DIV></DIV>';

        $this->reader->writeSource('/tags/generictag4.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag4.tpl.html');

        $view = $tmpl->getChild('runtime');

        $view->setAttribute("Align", "center");

        $output = $tmpl->capture();
        $this->assertEqual($output, '<DIV ID="runtime" Align="center"><DIV></DIV></DIV>');

    }

    function testNotAServerComponent() {
        $source = '<DIV><DIV ID="runtime"></DIV></DIV>';

        $this->reader->writeSource('/tags/generictag5.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag5.tpl.html');

        $this->assertFalse($tmpl->findChild('runtime'));

        $output = $tmpl->capture();
        $this->assertEqual($output, '<DIV><DIV ID="runtime"></DIV></DIV>');

    }

    function testNotAServerComponent2() {
        $source = '<DIV><DIV></DIV></DIV>';

        $this->reader->writeSource('/tags/generictag6.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag6.tpl.html');

        $this->assertFalse($tmpl->findChild('runtime'));

        $output = $tmpl->capture();
        $this->assertEqual($output, '<DIV><DIV></DIV></DIV>');
    }

    // Further odd cases

    function testGenericContainerCaseMismatch() {
        $source = '<DiV id="runtime" wact:id="*">Test</dIv>';

        $this->reader->writeSource('/tags/generictag13.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag13.tpl.html');

        $view = $tmpl->findChild('runtime');

        $output = $tmpl->capture();

        // This is expected behaviour but notice the parser has changed
        // the case of the closing tag
        $this->assertEqual($output, '<DiV id="runtime">Test</DiV>');
    }

    function testWactIdNotRendered() {
        // @TODO
        // Requires better integration with the close tag generation capabilities of Wact_View_Tag
        // To pass

        $source = '<DIV><DIV wact:id="runtime"></DIV></DIV>';
        $this->reader->writeSource('/tags/generictag14.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag14.tpl.html');
        $output = $tmpl->capture();
        $this->assertEqual($output, '<DIV><DIV></DIV></DIV>');
    }

    function testWactIdImpliesServer() {
        $source = '<DIV><DIV wact:id="runtime"></DIV></DIV>';
        $this->reader->writeSource('/tags/generictag15.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag15.tpl.html');
        $this->assertTrue($tmpl->findChild('runtime'));
    }

}
?>