<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* A node representing the unary minus operator
*/
class Wact_Template_Compiler_Expression_Node_UnaryMinus extends Wact_Template_Compiler_Expression_Node_Unary {
    
    /**
    * Return this value as a PHP value
    * @return String
    */
    function getValue() {
        // How do we handle divide by zero?
        if ($this->isConstant()) {
            return -($this->operand->getValue());
        } else {
            parent::getValue();
        }
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param Wact_Php_Writer
    * @return void
    */
    function generateExpression($code) {
        $code->writePHP('(-');
        $this->operand->generateExpression($code);
        $code->writePHP(')');
    }
    
}

?>