<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Base class for all Unary expression nodes
*/
abstract class Wact_Template_Compiler_Expression_Node_Unary extends Wact_Template_Compiler_Expression_Node {

    protected $operand;

    function __construct($operand) {
        $this->operand = $operand;
    }

    function isConstant() {
        return $this->operand->isConstant();
    }
    
    function generatePreStatement($code) {
        $this->operand->generatePreStatement($code);
    }

    function generateExpression($code) {
        $this->operand->generateExpression($code);
    }

    function generatePostStatement($code) {
        $this->operand->generatePostStatement($code);
    }

    function prepare() {
        $this->operand->prepare();
    }
    
}

?>