<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Escape HTML
*/
class Wact_Template_Compiler_Expression_Node_Html extends Wact_Template_Compiler_Expression_Node_Unary {

    /**
    * Return this value as a PHP value
    * @return String
    */
    function getValue() {
        if ($this->isConstant()) {
            return htmlspecialchars($this->operand->getValue(), ENT_QUOTES);
        } else {
            parent::getValue();
        }
    }
    
    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param Wact_Php_Writer
    * @return void
    */
    function generateExpression($code) {
        $code->writePHP('htmlspecialchars(');
        $this->operand->generateExpression($code);
        $code->writePHP(', ENT_QUOTES)');
    }
    
}

?>