<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* A property representing a constant value.
*/
class Wact_Template_Compiler_Expression_Node_Array extends Wact_Template_Compiler_Expression_Node {
    
    private $valueList;
    
    function __construct($valueList) {
        $this->valueList = $valueList;
    }

    /**
    * Does this property refer to a constant value at compile time?
    * @return Boolean
    */
    function isConstant() {
        foreach ($this->valueList as $key => $value) {
            if (!$value->isConstant()) {
                return FALSE;
            }
        }
        return TRUE;
    }

    /**
    * Return this value as a PHP value
    * @return String
    */
    function getValue() {
        $array = array();
        foreach ($this->valueList as $key => $value) {
            $array[$key] = $value->getValue();
        }
        return $array;
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param Wact_Php_Writer
    * @return void
    */
    function generateExpression($code) {
        $code->writePHP('array(');
        foreach ($this->valueList as $key => $value) {
            $code->writePHP(var_export($key, TRUE));
            $code->writePHP("=>");
            $value->generateExpression($code);
            $code->writePHP(",");
        }
        $code->writePHP(")\n");
    }

    function generatePreStatement($code) {
        foreach ($this->valueList as $key => $value) {
            $value->generatePreStatement($code);
        }
    }

    function generatePostStatement($code) {
        foreach ($this->valueList as $key => $value) {
            $value->generatePostStatement($code);
        }
    }

    function prepare() {
        foreach ($this->valueList as $key => $value) {
            $value->prepare();
        }
    }
    
}

?>