<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Base class for all expression nodes
*/
abstract class Wact_Template_Compiler_Expression_Node {

    /**
    * Does this expression refer to a constant value (at compile time)?
    * @return Boolean
    */
    function isConstant() {
    }

    /**
    * Return the value of this expression
    * @return String
    */
    function getValue() {
        throw new Wact_Template_Compiler_Exception("Cannot evaluate non-constant expression during templating compilation");
    }

    /**
    * Generate setup code for an expression reference
    * @param Wact_Php_Writer
    * @return void
    */
    function generatePreStatement($code) {
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param Wact_Php_Writer
    * @return void
    */
    function generateExpression($code) {
    }

    /**
    * Generate tear down code for an expression reference
    * @param Wact_Php_Writer
    * @return void
    */
    function generatePostStatement($code) {
    }

    /**
    * Calls the prepare method on the root of the formatter chain
    * @return void
    */
    function prepare() {
    }

}


?>