<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class Wact_Template_Compiler_Attribute_Fragment_Literal {

    /**
    * The Attribute Value
    */
    protected $value;

    /**
    */
    function __construct($value) {
        $this->value = $value;
    }

    /**
    * Can a PHP value for this reference be calculated at compile time?
    * @return Boolean
    */
    function isConstant() {
        return TRUE;
    }

    /**
    * Return the value of this attribute
    * @return String
    */
    function getValue() {
        return $this->value;
    }

    /**
    * Generate the code
    * @param CodeWriter
    * @return void
    */
    function generate($code) {
        $code->writeHTML($this->value);
    }

    /**
    * Generate setup code for an expression reference
    * @param CodeWriter
    * @return void
    */
    function generatePreStatement($code) {
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param CodeWriter
    * @return void
    */
    function generateExpression($code) {
        $code->writePHPLiteral($this->value);
    }

    /**
    * Generate tear down code for an expression reference
    * @param CodeWriter
    * @return void
    */
    function generatePostStatement($code) {
    }

    /**
    * Prepare this attribute to be used
    * @return void
    */
    function prepare() {
    }

}

?>