<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Stores literal attributes found inside tag components
*/
class Wact_Template_Compiler_Attribute {

    /**
    * Define an attribute which has special meaning to distinguish tags that
    * will get mapped to components.
    */
    const WACT_ID = 'wact:id'; // Must be lower case!

    const WACT_ID_UNSPECIFIC = '*';

    /**
    * The Attribute name
    */
    public $name;

    /**
    * The Attribute Value
    */
    protected $value;

    function __construct($name, $value) {
        $this->name = $name;
        $this->value = $value;
    }

    /**
    * Can a PHP value for this reference be calculated at compile time?
    * @return Boolean
    */
    function isConstant() {
        return TRUE;
    }

    /**
    * Return the value of this attribute
    * @return String
    */
    function getValue() {
        return $this->value;
    }

    /**
    * Return the value of this attribute
    * @return String
    */
    function getValueEscaped() {
        return $this->value;
    }

    /**
    * Generate the code
    * @param CodeWriter
    * @return void
    */
    function generate($code) {
        $code->writeHTML(' ' . $this->name);
        if (!is_null($this->value)) {
            $code->writeHTML('="');
            $code->writeHTML($this->value);
            $code->writeHTML('"');
        }
    }

    /**
    * Generate setup code for an expression reference
    * @param CodeWriter
    * @return void
    */
    function generatePreStatement($code) {
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param CodeWriter
    * @return void
    */
    function generateExpression($code) {
        $code->writePHPLiteral($this->value);
    }

    /**
    * Generate tear down code for an expression reference
    * @param CodeWriter
    * @return void
    */
    function generatePostStatement($code) {
    }

    /**
    * Prepare this attribute to be used
    * @return void
    */
    function prepare() {
    }

}

?>