<?php
/**
 * Web Application Component Toolkit
 *
 * @link http://www.phpwact.org/
 *
 * @author Wact Development Team
 * @link http://www.phpwact.org/team
 *
 * @copyright Copyright 2006, Jeff Moore
 * @license http://opensource.org/licenses/mit-license.php MIT
 */

/**
 *
 */
class Wact_Reflection_Property extends ReflectionProperty {

    /**
     * @return Wact_Reflection_Class
     */
    public function getDeclaringClass() {
        return new Wact_Reflection_Class(parent::getDeclaringClass()->getName());
    }

    /**
     * Return the type of this parameter
     * @return string type of this parameter accounting for docblocks
     */
    public function getType() {
        $comment = $this->getDocComment();
        if ($comment) {
            $pattern = '/^\s*\*\s+@var\s+(\w+)/m';
            if (preg_match($pattern, $comment, $tagMatches)) {
                return $tagMatches[1];
            }
        }
        return NULL; // Unknown
    }
    
}

?>