<?php

class WactReflectionParameterTester {
    /**
     * @param int $x
     */
    function foo($x) {
    }
}

class WactReflectionParameterHintTester {
    function foo(WactReflectionParameterTester $x) {
    }
}

function WactReflectionParameterTester($x) {
}

class WactReflectionParameterTestCase extends Wact_Test_Case {
    
    function testGetDeclaringClass() {
        $class = new Wact_Reflection_Class('WactReflectionParameterTester');
        $method = $class->getMethod('foo');
        foreach($method->getParameters() as $name => $parameter) {
            $class = $parameter->getDeclaringClass();
            $this->assertIsA($class, 'Wact_Reflection_Class');
            $this->assertEqual($class->getName(), 'WactReflectionParameterTester');
        }
    }

    function testGetDeclaringClassOnFunction() {
        $func = new Wact_Reflection_Function('WactReflectionParameterTester');
        foreach($func->getParameters() as $name => $parameter) {
            $class = $parameter->getDeclaringClass();
            $this->assertNull($class);
        }
    }

    function testGetDeclaringFunction() {
        $func = new Wact_Reflection_Function('WactReflectionParameterTester');
        foreach($func->getParameters() as $name => $parameter) {
            $class = $parameter->getDeclaringFunction();
            $this->assertIsA($class, 'Wact_Reflection_Function');
            $this->assertEqual($class->getName(), 'WactReflectionParameterTester');
        }
    }

    function testGetDeclaringFunctionOnClass() {
        $class = new Wact_Reflection_Class('WactReflectionParameterTester');
        $method = $class->getMethod('foo');
        foreach($method->getParameters() as $name => $parameter) {
            $class = $parameter->getDeclaringFunction();
            $this->assertIsA($class, 'Wact_Reflection_Class');
            $this->assertEqual($class->getName(), 'WactReflectionParameterTester');
        }
    }
    
    function testGetClass() {
        $class = new Wact_Reflection_Class('WactReflectionParameterHintTester');
        $method = $class->getMethod('foo');
        foreach($method->getParameters() as $name => $parameter) {
            $class = $parameter->getClass();
            $this->assertIsA($class, 'Wact_Reflection_Class');
            $this->assertEqual($class->getName(), 'WactReflectionParameterTester');
        }
    }

    function testGetClassWithNoHint() {
        $class = new Wact_Reflection_Class('WactReflectionParameterTester');
        $method = $class->getMethod('foo');
        foreach($method->getParameters() as $name => $parameter) {
            $class = $parameter->getClass();
            $this->assertNull($class);
        }
    }
    
    function testGetTypeOnDocblockOnlyType() {
        $class = new Wact_Reflection_Class('WactReflectionParameterTester');
        $method = $class->getMethod('foo');
        foreach($method->getParameters() as $name => $parameter) {
            $this->assertEqual($parameter->getType(), 'int');
        }
    }

    function testGetTypeWithTypeHint() {
        $class = new Wact_Reflection_Class('WactReflectionParameterHintTester');
        $method = $class->getMethod('foo');
        foreach($method->getParameters() as $name => $parameter) {
            $this->assertEqual($parameter->getType(), 'WactReflectionParameterTester');
        }
    }
    
}    
?>