<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class Wact_Php_Writer_Global extends Wact_Php_Writer_Block {

    /**
    * List of files to write include statements for
    * @var Wact_Php_Writer_Include
    */
    protected $includes = array();

    /**
    * Adds an include file to the internal list.
    * Checks that file has not already been included.
    * Note that the path to the file to be included will need to
    * be in PHP's runtime include path.
    * @param string $fileName
    */
    public function registerInclude($fileName) {
        if (!in_array($fileName, $this->includes)) {
            $this->includes[] = $fileName;
        }
    }

    /**
    * Returns the include file list.
    * @return array
    */
    public function getIncludes() {
        return $this->includes;
    }

    /**
    * Returns the finished include block.
    * Keeps the initial context (PHP/HTML). PHP tags are added where necessary.
    * @param array $list List of files to generate code for. Defaults to the internal array.
    * @return string
    */
    public function getIncludeCode($list = null) {
        $code = '';

        if ($list == null) {
            $list = $this->getIncludes();
        }

        $includes = array_unique($list);
        if (count($includes) > 0) {
            if ($this->defaultMode == self::MODE_HTML) {
                $code .= '<' . '?php' . "\n";
            }
            foreach ($includes as $includeName) {
                $code .= "require_once '" . $includeName . "';\n";
            }
            if ($this->defaultMode == self::MODE_HTML) {
                $code .= '?' . '>';
            }
        }

        return $code;
    }

    /**
    * Returns the include code + the finished block code.
    * Keeps the initial context (PHP/HTML). PHP tags are added where necessary.
    * @return string
    */
    public function getCode() {
        return $this->getIncludeCode() . $this->getBlockCode();
    }

}

?>