<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Provides an API for generating PHP functions.
* This class starts out in PHP mode thus the code it returns
* always assumes the PHP context (i.e. adds NO PHP tags internally).
*/
abstract class Wact_Php_Writer_Callable extends Wact_Php_Writer_Block {

    /**
    * Name of the function
    * @var string
    */
    protected $name;

    /**
    * Parameter list (without the brackets)
    * @var string
    */
    protected $params;

    /**
    * Class constructor
    * @param string $name Name of the function
    * @param string $params Parameter list (without the brackets)
    */
    public function __construct($name, $params = null) {
        if (!preg_match('/^[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*$/', $name)) {
            throw new Wact_Php_Writer_Exception('Invalid Identifier "{Identifier}"', $name);
        }
        $this->name = $name;
        $this->params = $params;

        parent::__construct(Wact_Php_Writer_Block::MODE_PHP);
    }

    /**
    * Returns the finished function code.
    * This class is designed to output into PHP context.
    * No PHP tags are added internally.
    * @return string
    */
    public function getBlockCode() {
        $code = 'function ' . $this->name . '(' . $this->params . ') {' . "\n";
        $code .= parent::getBlockCode();
        $code .= "\n}";

        return $code;
    }

    /**
    * Returns the name of the function
    * @return string Name of the function
    */
    public function getName() {
        return $this->name;
    }

    /**
    * Returns the function parameters
    * @return string Function parameters (without the brackets)
    */
    public function getParams() {
        return $this->params;
    }
}

?>