<?php

class WactHtmlExceptionMessageFormatterTestCase extends Wact_Test_Case {

    function testConvertToHtmlLeadingSpaces() {
        $message = ' Test';
        $result = Wact_Exception_Formatter_Html::convertToHtml($message);
        $this->assertEqual($result, '&nbsp;Test');
    }

    function testConvertToHtmlIndentation() {
        $message = "Test:\n indent";
        $result = Wact_Exception_Formatter_Html::convertToHtml($message);
        $this->assertEqual($result, "Test:<br />\n&nbsp;indent");
    }

    function testConvertToHtmlIndentation4() {
        $message = "Test:\n    indent";
        $result = Wact_Exception_Formatter_Html::convertToHtml($message);
        $this->assertEqual($result, "Test:<br />\n&nbsp;&nbsp;&nbsp;&nbsp;indent");
    }

}

?>
