<?php

class Wact_Exception_BaseTestCase extends Wact_Test_Case {

    function testThrowing() {
        try {
            throw new Wact_Exception_Base('This is a test');
            $this->fail('Expected exception not thrown');
        } catch (Wact_Exception_Base $e) {
            $this->pass();
        }
    }
    
    function testSimpleMessage() {
        $message = 'This is a test';
        $e = new Wact_Exception_Base($message);
        $this->assertEqual($e->getMessage(), $message);
    }

    function testMessageWithSubstitution() {
        $data = 'Foo';
        $e = new Wact_Exception_Base('This is a test {Substitute}', $data);
        $this->assertEqual($e->getSubstitute(), $data);
    }

    function testUndefinedAccessor() {
        $this->expectError("Accessing undefined variable 'Substitute'");
        $e = new Wact_Exception_Base('This is a test');
        $e->getSubstitute();
    }
    
    function testCaseInsensitive() {
        $data = 'Foo';
        $e = new Wact_Exception_Base('This is a test {SubStitute}', $data);
        $this->assertEqual($e->getSubstitute(), $data);
    }
    
    function testReservedVariableName() {
        $data = 'Foo';
        $this->expectError("Substitution variable 'Message' is reserved");
        $e = new Wact_Exception_Base('This is a test {Message}', $data);
    }

    function testTooManyParameters() {
        $data = 'Foo';
        $this->expectError("1 unconsumed constructor parameters to Wact_Exception_Base");
        $e = new Wact_Exception_Base('This is a test', $data);
    }

    function testExtraParametersWithSimpleMessage() {
        $data = 'Foo';
        $message = 'This is a test';
        $e = new Wact_Exception_Base($message, array('Extra' => $data));
        $this->assertEqual($e->getMessage(), $message);
        $this->assertEqual($e->getExtra(), $data);
    }

    function testExtraParametersWithSubstitution() {
        $data = 'Foo';
        $e = new Wact_Exception_Base('This is a test {Substitute}', $data,
            array('Extra' => $data));
        $this->assertEqual($e->getSubstitute(), $data);
        $this->assertEqual($e->getExtra(), $data);
    }

    function testCause() {
        $cause = new Exception("Foo");
        $e = new Wact_Exception_Base('This is a test', $cause);
        $this->assertIdentical($e->getCause(), $cause);
    }
    
}

?>
