<?php
/**
 * Web Application Component Toolkit
 *
 * @link http://www.phpwact.org/
 *
 * @author Wact Development Team
 * @link http://www.phpwact.org/team
 *
 * @copyright Copyright 2006, Jeff Moore
 * @license http://opensource.org/licenses/mit-license.php MIT
 */

/**
 * This class handles php errors, printing debugging information.
 * Use this only for debugging.
 */
class Wact_Error_Handler {

    /**
     */
    protected $oldHandler;

    /**
     * Handle errors
     *
     * @param unknown_type $errno
     * @param unknown_type $errmsg
     * @param unknown_type $filename
     * @param unknown_type $linenum
     * @param unknown_type $vars
     */
    public function handleError($errno, $errmsg, $filename, $linenum, $vars) {

        if ( ( $errno & error_reporting() ) != $errno ) {
            return; // Ignore this error because of error suppression
        }

        $errortype = array (
            E_ERROR       => 'Error',
            E_WARNING      => 'Warning',
            E_PARSE       => 'Parsing Error',
            E_NOTICE       => 'Notice',
            E_CORE_ERROR     => 'Core Error',
            E_CORE_WARNING    => 'Core Warning',
            E_COMPILE_ERROR   => 'Compile Error',
            E_COMPILE_WARNING  => 'Compile Warning',
            E_USER_ERROR     => 'User Error',
            E_USER_WARNING    => 'User Warning',
            E_USER_NOTICE    => 'User Notice',
            E_STRICT       => 'Runtime Notice'
            );

        if (php_sapi_name() == 'cli') {

            die("CLI error message formatting unimplemented.");

        } else {
            $formatter = new Wact_Error_Formatter_Html();
        }

        $formatter->beginError();

        $formatter->writeErrorMessage($errmsg,
            $filename, $linenum, $errortype[$errno]);

        $formatter->writeStackTrace(debug_backtrace());

        $formatter->endError();

        echo $formatter->getMessage();
    }

    /**
     */
    public function install() {
        $this->oldHandler = set_error_handler(array($this, 'handleError'));
    }

    /**
     */
    public function uninstall() {
        set_error_handler($this->oldHandler);
    }

}

?>