<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Turn a console oriented exception message into an HTML message.
*/
class Wact_Error_Formatter_Html extends Wact_Error_Formatter_Html_StackTrace implements Wact_Error_Formatter {

    /**
    */
    function beginError() {
        $this->message .=  "<table style='color:black;background-color:white' border='1' cellspacing='0'>\n";
    }

    /**
    */
    function endError() {
        $this->message .= "</table>";
    }

    /**
    */
    function writeErrorMessage($message, $file, $line, $level) {
        $this->message .= "<tr>\n";
        $this->message .= "<td bgcolor='#ff9999'>\n";
        $this->message .= '<b>' . $level . '</b>: ';
        $this->message .= '<i>' . htmlspecialchars($message) . '</i>';
        $this->message .= ' in <b>' . $file . '</b> on line <b>' . $line . "</b>\n";
        $this->message .= "<br />\n";

        $this->message .= "</td>\n";
        $this->message .= "</tr>\n";
    }
    
}

?>