<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* A transient cache.  This object caches data items until the end of the 
* current request.
*/
class Wact_Cache_Store_Transient implements Wact_Cache_Store {

    /**
    * A hash table of the items stored in this cache.
    * @var array
    */
    protected $items = array();

    /**
    * @see Wact_Cache_Store.store
    */
    public function store($key, $data, $lifetime = NULL) {
        if ($lifetime !== NULL && $lifetime !== 0) {
            throw new Wact_Cache_Exception(
                'Wact_Cache_Store_Transient does not support expiring');
        }
        settype($key, 'string');
        $this->items[$key] = (string) $data;
        return TRUE;
    }

    /**
    * @see Wact_Cache_Store.storeValue
    */
    public function storeValue($key, $data, $lifetime = NULL) {
        if ($lifetime !== NULL && $lifetime !== 0) {
            throw new Wact_Cache_Exception(
                'Wact_Cache_Store_Transient does not support expiring');
        }
        settype($key, 'string');
        $this->items[$key] = $data;
        return TRUE;
    }
    
    /**
    * @see Wact_Cache_Store.fetch
    */
    public function fetch($key, $default = NULL) {
        settype($key, 'string');
        if (isset($this->items[$key])) {
            return (string) $this->items[$key];
        } else {
            return $default;
        }
    }

    /**
    * @see Wact_Cache_Store.fetch
    */
    public function fetchValue($key, $default = NULL) {
        settype($key, 'string');
        if (isset($this->items[$key])) {
            return $this->items[$key];
        } else {
            return $default;
        }
    }
    
    /**
    * @see Wact_Cache_Store.includeCode
    */
    public function includeCode($key) {
        settype($key, 'string');
        if (isset($this->items[$key])) {
            // Strange concatination works better with source code parsing tools
            $result = eval(' ?' . '>' . $this->items[$key] . '<' . '?php ');

            if (is_null($result)) {
                return TRUE;
            } else {
                return $result;
            }
        }
        return FALSE;
    }
    
    /**
    * @see Wact_Cache_Store.remove
    */
    public function remove($key) {
        settype($key, 'string');
        unset($this->items[$key]);
        return TRUE;
    }
    
    /**
    * @see Wact_Cache_Store.clear
    */
    public function clear() {
        $this->items = array();
        return TRUE;
    }
    
}

?>