<?php
/**
 * Web Application Component Toolkit
 *
 * @link http://www.phpwact.org/
 *
 * @author Wact Development Team
 * @link http://www.phpwact.org/team
 *
 * @copyright Copyright 2006, Jeff Moore
 * @license http://opensource.org/licenses/mit-license.php MIT
 */

/**
 * Cache arbitrary data items
 */
interface Wact_Cache_Store {

    /**
     * Stores a data string in the cache.
     * @param string Key Identifier for the cached item
     * @param string data to store in the cache
     * @param int Lifetime in seconds, 0 for never expires
     * @return boolean FALSE if the data was not stored
     */
    public function store($key, $data, $lifetime = NULL);
    
    /**
     * Stores a data value in the cache.  
     * This function can store any serializable PHP data type.
     * @param string Key identifier for the cached item
     * @param mixed data data to store in the cache
     * @param int Lifetime in seconds, 0 for never expires
     * @return boolean FALSE if the data was not stored
     */
    public function storeValue($key, $data, $lifetime = NULL);
    
    /**
     * Retreives a data item from the cache.
     * Do not use fetch to retreive values stored with StoreValue or
     * StoreManyValues.
     * @param string $key Identifier for the cached item
     * @return string|mixed Returns a cached cached data string, or
     *       the default parameter if the item could not be found.
     */
    public function fetch($key, $default = NULL);

    /**
     * Retreives a data item from the cache.
     * Do not use fetchValue to retreive values stored with Store or
     * StoreMany.
     * @param string $key Identifier for the cached item
     * @return mixed Returns a cached cached data string, or
     *       the default parameter if the item could not be found.
     */
    public function fetchValue($key, $default = NULL);
    
    /**
     * Treat the cached data item as PHP code and includes that code.
     * Returns any value returned by the code, FALSE if the code could not
     * be included or TRUE if there was no return value from inclusion.
     * Including code that explicitly returns NULL or FALSE can case the
     * return value of this function to be incorrect.
     * @param string $key Identifier for the cached item
     * @return mixed returns FALSE if the item could not be included.
     */
    public function includeCode($key);

    /**
     * Remove a previously cached item from the cache.
     * @param string key Identifier for the cached item
     * @return boolean returns FALSE if the item was not removed.
     */
    public function remove($key);
    
    /**
     * Remove all cached data.
     * @return boolean returns FALSE on error.
     */
    public function clear();

}

?>