<?php

/*
Example Name: Case Converter
Description: A simple form to demonstrate using controllers with templates
*/

require_once '../../Wact/Loader.inc.php';
Wact_Loader::setupWact();

class CaseConverter extends Wact_Controller_Base {

    function setup() {
        $this->setView('index.tpl.html');
     
        $this->defineInput(new Wact_Request_Post('text'))->bindToModel();
        $this->dispatchOn(new Wact_Request_PostButton('action', array('upper', 'lower')));

        $this['upper']->onExecuteDo($this, 'toUpper');
        $this['lower']->onExecuteDo($this, 'toLower');

    }

    function toLower($source, $request, $responseModel) {
        $responseModel->text = strtolower($responseModel->text);
    }

    function toUpper($source, $request, $responseModel) {
        $responseModel->text = strtoupper($responseModel->text);
    }

}

$config = new Wact_Config_Registry();
$config->CaseConverter->start();

?>