<?php

class HangmanGame {
    var $word;
    var $level;
    var $levels = array('easy' => 10, 'medium' => 5, 'hard' => 3);
    var $guesses = '';
    var $misses = 0;

    function pickRandomWord() {
        $words = preg_split("/[\s,]+/", file_get_contents('constitution.txt'));
        do {
            $i = rand(0, count($words) - 1);
            $word = $words[$i];
        } while(strlen($word) < 5 || !preg_match('/^[a-z]*$/i', $word));
        $this->word = strtoupper($word);
    }
    
    function guess($letter) {
        $this->guesses .= $letter;

        if (!is_integer(strpos($this->word, $letter))) {
            $this->misses++;
        }
    }
    
    function hasLost() {
        return ($this->misses >= $this->level);
    }

    function hasWon() {
        for ($i = 0; $i < strlen($this->word); $i++) {
            if (!is_integer(strpos($this->guesses, $this->word{$i}))) {
                return FALSE;
            }
        }
        return TRUE;
    }
 
}

?>