<?php

class TagViewTestCase extends Wact_View_Partial_Test {

    function setUp() {
        $this->view = new Wact_View_Tag('test', array(), FALSE);
    }

    function testGetClientId() {
        $this->view->setAttribute('id', 'TestId');
        $this->assertEqual($this->view->getClientId(), 'TestId');
    }

    function testGetClientIdUnset() {
        $this->assertNull($this->view->getClientId());
    }

    function testGetAttribute() {
        $this->view->setAttribute('foo', 'bar');
        $this->assertEqual($this->view->getAttribute('foo'), 'bar');
        $this->assertEqual($this->view->getAttribute('FOO'), 'bar');
    }

    function testGetUnsetAttribute() {
        $this->assertNull($this->view->getAttribute('class'));
    }

    function testHasAttributeUnset() {
        $this->assertFalse($this->view->hasAttribute('class'));
    }

    function testRemoveAttribute() {
        $this->view->setAttribute('foo', 'bar');
        $this->view->setAttribute('untouched', 'value');
        $this->assertTrue( $this->view->hasAttribute('foo'));                    
        $this->view->removeAttribute('FOO');
        $this->assertFalse( $this->view->hasAttribute('foo'));                    
    }

    function testHasAttribute() {
        $this->view->setAttribute('foo', 'bar');
        $this->view->setAttribute('tricky', NULL);
        $this->assertTrue( $this->view->hasAttribute('foo'));                    
        $this->assertTrue( $this->view->hasAttribute('tricky'));                    
        $this->assertFalse( $this->view->hasAttribute('missing'));                    
        $this->assertTrue( $this->view->hasAttribute('FOO'));                    
        $this->assertTrue( $this->view->hasAttribute('TRICKY'));                    
        $this->assertFalse( $this->view->hasAttribute('MISSING'));                    
    }

    function testGetAttributeUnset() {
        $this->assertNull($this->view->getAttribute('foo'));
    }

    function testPaintOpen() {
        $this->view->setAttribute('a', 'red');
        $this->view->setAttribute('b', 'blue');
        $this->view->setAttribute('c', 'green');
        ob_start();
        $this->view->paintOpen();
        $output = ob_get_contents();
        ob_end_clean();
        $this->assertEqual('<test a="red" b="blue" c="green"/>',$output);
    }

    function testpaintOpenXMLStyle() {
        $view = new Wact_View_Tag('test', array(), FALSE);
        ob_start();
        $view->paintOpen();
        $output = ob_get_contents();
        ob_end_clean();
        $this->assertEqual('<test/>', $output);
    }
    
    function testPaintClose() {
        $this->view->appendChild(new Wact_View_Partial());
        ob_start();
        $this->view->paintClose();
        $output = ob_get_contents();
        ob_end_clean();
        $this->assertEqual('</test>',$output);
    }

}

?>