<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class WebTestRunningInterface {

    var $collector;
    var $config;
    var $coverageInclude;
    var $coverageStatus = FALSE;
    protected $selected;
    
    /**
    */
    function __construct($config, $collector) {
        $this->collector = $collector;
        $this->config = $config;
    }
    
    /**
    * Returns a NullReporter to be used when generating a code coverage report
    */
    function getNullReporter() {
        $reporter = new Wact_Test_Reporter_Null();
        $reporter->setInterface($this);
        return $reporter;
    }

    /**
    * Returns a Wact_Test_Reporter_Html to be used when running the tests
    */
    function getHtmlIterfaceReporter() {
        $reporter = new Wact_Test_Reporter_Html();
        $reporter->setInterface($this);
        return $reporter;
    }

    /**
    */
    function getHref($params = array()) {

        if (isset($this->coverageInclude) && $this->coverageInclude != '') {
            $params['covinclude'] = $this->coverageInclude;
        }

        $base = $_SERVER['PHP_SELF'];
        $parameterStr = '';
        foreach ($params as $name => $value) {
            if (empty($parameterStr)) {
                $parameterStr = $name . '=' . urlencode($value);
            } else {
                $parameterStr .= '&' . $name . '=' . urlencode($value);
            }
        }
        if (empty($parameterStr)) {
            return $base;
        } else {
            return $base . '?' . $parameterStr;
        }
    }

    /**
    */
    function printHeader() {
        ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>Welcome to Wact</title>
<link rel="stylesheet" type="text/css" href="http://yui.yahooapis.com/2.2.0/build/reset-fonts-grids/reset-fonts-grids.css">
<link rel="stylesheet" type="text/css" href="http://yui.yahooapis.com/2.3.0/build/base/base-min.css">
<STYLE type="text/css">
#hd {
    color: white;
    background-color: #4d6d80;
    padding: 2em;
}
#hd h1 {
    font-size:277%;
}
#hd .tag {
    float:right;
}
#hd .description {
    clear:both;
}
#ft {
    background-color: #4d6d80;
}
#test-tree table {
    margin-bottom: 0;
}
#test-tree th, td {
    border:0;
    padding:0;
}
</STYLE>
  <!-- Required CSS -->
  <link type="text/css" rel="stylesheet" href="http://yui.yahooapis.com/2.3.0/build/treeview/assets/skins/sam/treeview.css">
 
  <!-- Dependency source files --> 
  <script src="http://yui.yahooapis.com/2.3.0/build/yahoo/yahoo-min.js" type="text/javascript"></script>
  <script src="http://yui.yahooapis.com/2.3.0/build/event/event-min.js" type="text/javascript"></script>

  <!-- TreeView source file --> 
  <script src="http://yui.yahooapis.com/2.3.0/build/treeview/treeview-min.js" type="text/javascript"></script>
</head>
<body>
<div id="doc3" class="yui-t3">
   <div id="hd">

<div class="tag">Wact Test Runner</div>
<h1>Wact Tests</h1>
<div class="description">
</div>

   </div>
    <div id="yui-main">
    <div class="yui-b"><div class="yui-g">
<?php
    }

    /**
    */
    function printFooter() {
?>
    </div>
</div>
    </div>
    <div class="yui-b">
<script type="text/javascript">
(function() {
    var tree;
    
    function buildtree() {
    <?php
        $dirs = $this->collector->getDirs();
        $root = $this->collector->getTestCaseDir();
        $start = strlen($root);

        $varCount = 1;
        $stack = array('/');
        $vars = array();
        foreach($dirs as $dir => $count) {
            $shortdir = substr($dir, $start);
            
            $myVar = 'tmp' . $varCount++;
            
            if (empty($shortdir)) {
                $parentVar = 'tree.getRoot()';
                array_unshift($stack, '/');
                $vars['/'] = $myVar;
            } else {
                $vars[$shortdir] = $myVar;
                while ( ($stack) && (strpos($shortdir, $stack[0]) !== 0) && (array_shift($stack)) ) {}
                if (empty($stack)) {
                    $parentVar = 'tree.getRoot()';
                    array_unshift($stack, '/');
                } else {
                    $parentVar = $vars[$stack[0]];
                    array_unshift($stack, $shortdir);
                }
            }

            echo 'var ', $myVar, ' = new YAHOO.widget.HTMLNode(';

            echo '"';
            echo "<a href='", $this->getHref(array('testdir' => $shortdir)), "'>";
            if ($dir == $root) {
                echo 'all';
            } else {
                echo basename($shortdir);
            }
            echo "<\\/a> ", $count;
            echo '", ';
            
            echo $parentVar, ', ';
            if (strpos($this->selected, $shortdir) === 0) {
                echo 'true';
            } else {
                echo 'false';
            }
            echo ', true);', "\n";

            $tests = $this->collector->getTests($dir);
            foreach($tests as $test) {
                $shortfile = substr($test, $start);
                if (dirname($test) !== $dir) continue;
                
                echo 'var tmp = new YAHOO.widget.HTMLNode(';
                echo '"';
                echo "<a href='", $this->getHref(array('testfile' => $shortfile)), "'>";
                if ($dir == $root) {
                    echo 'all';
                } else {
                    echo basename($shortfile);
                }
                echo "<\\/a>";
                echo '", ';
                
                echo $myVar, ', false, true);', "\n";
            }

        }
        echo "tmp1.expand()";
    ?>
    }
    
    function treeInit() {

        tree = new YAHOO.widget.TreeView("test-tree");
        
        buildtree();

        YAHOO.util.Event.on("expand", "click", function(e) {
            tree.expandAll();
            YAHOO.util.Event.preventDefault(e);
        });
        
        YAHOO.util.Event.on("collapse", "click", function(e) {
            tree.collapseAll();
            YAHOO.util.Event.preventDefault(e);
        });

        tree.draw();
    }
    
    YAHOO.util.Event.onDOMReady(treeInit);
    
})();
</script>
<div id="expandcontractdiv">
    <a id="expand" href="#">Expand all</a>
    <a id="collapse" href="#">Collapse all</a>
</div>

<div id="test-tree"></div>
    
    </div>
    <div id="ft">&nbsp;</div>
</div>
</body>
</html>
    <?php
    }

    /**
    */
    function chooseTestPage() {
        $this->printHeader();
        $this->printFooter();
    }

    /**
    */
    function doRunTestFileCommand($file) {
        $manager = new Wact_Test_Manager($this->config, $this->collector);
        $realfile = $this->collector->getTestCaseDir() . $file;
        $title = "test cases from " . $file;
        $manager->runTestFile($realfile, $this->getHtmlIterfaceReporter(), $title);
    }

    /**
    */
    function doRunTestDirCommand($dir) {
        $manager = new Wact_Test_Manager($this->config, $this->collector);
        $realdir = $this->collector->getTestCaseDir() . $dir;
        $title = "test cases from " . $dir;
        $manager->runTestDir($realdir, $this->getHtmlIterfaceReporter(), $title);
    }

    /**
    */
    function doRunCoverageFileCommand($file, $reporter) {
        $reporterClass = 'Wact_Test_Coverage_Reporter_' . $reporter;
        $coverageReporter = new $reporterClass();
        
        $manager = new Wact_Test_Manager($this->config, $this->collector);
        $realfile = $this->collector->getTestCaseDir() . $file;
        if (isset($this->coverageInclude)) {
            $manager->setCoverageInclude($this->coverageInclude);
        }
        $manager->coverFile($realfile, $coverageReporter, $this->getNullReporter());
        // header('Location: ' . $this->config->coverage_report_url);
    }

    /**
    */
    function doRunCoverageDirCommand($dir, $reporter) {
        $reporterClass = 'Wact_Test_Coverage_Reporter_' . $reporter;
        $coverageReporter = new $reporterClass();
    
        $manager = new Wact_Test_Manager($this->config, $this->collector);
        $realdir = $this->collector->getTestCaseDir() . $dir;
        if (isset($this->coverageInclude)) {
            $manager->setCoverageInclude($this->coverageInclude);
        }
        $manager->coverDir($realdir, $coverageReporter, $this->getNullReporter());
        // header('Location: ' . $this->config->coverage_report_url);
    }
    
    /**
    */
    function start() {
        $this->collector->collect($this->config->test_case_dir);

        /*
        if (isset($_GET['covinclude'])) {
            $this->coverageInclude = $_GET['covinclude'];
        }
        */
        if (isset($_GET['coverdir'])) {
            $this->coverageInclude = $this->collector->getTestCaseDir() . $_GET['coverdir'];
        }
        
        if (isset($_GET['testdir'])) {
            $this->selected = $_GET['testdir'];
            $this->doRunTestDirCommand($_GET['testdir']);
        } elseif (isset($_GET['testfile'])) {
            $this->selected = dirname($_GET['testfile']);
            $this->doRunTestFileCommand($_GET['testfile']);
        } elseif (isset($_GET['coverfile']) /*&& $this->coverageStatus*/ ) {
            $this->doRunCoverageFileCommand($_GET['coverfile'], (isset($_GET['coverreporter']) ? $_GET['coverreporter'] : 'Html'));
        } elseif (isset($_GET['coverdir']) /*&& $this->coverageStatus*/ ) {
            $this->doRunCoverageDirCommand($_GET['coverdir'], (isset($_GET['coverreporter']) ? $_GET['coverreporter'] : 'Html'));
        } else {
            $this->chooseTestPage();
        }
    }
    
}

?>