<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* File level includes
*/
require_once 'simpletest/reporter.php';
require_once 'simpletest/web_tester.php';
require_once 'simpletest/mock_objects.php';

/**
*   Perform various testing functions
*/
class Wact_Test_Manager {

    var $collector;
    var $config;
    var $coverageInclude;
    
    /**
    */
    function __construct($config, $collector) {
        $this->config = $config;
        $this->collector = $collector;
    }

    /**
    */
    function setCoverageInclude($coverageInclude) {
        $this->coverageInclude = $coverageInclude;
    }

    /**
    */
    function loadEnvironment() {
        ini_set('log_errors', FALSE);
        error_reporting(E_ALL);
        set_time_limit(0);
    }
    
    /**
    */
    function getCoverageRecorder($coverageReporter) {
        $includePaths = $this->config->coverage_include_paths;
        if (isset($this->coverageInclude)) {
            $includePaths = array($this->coverageInclude);
        }

        $excludePaths = $this->config->coverage_exclude_paths;
        $excludePaths[] = $this->config->test_temp_dir;
        
        $cov = new Wact_Test_Coverage_Recorder_Xdebug($includePaths, $excludePaths, $coverageReporter);
        $cov->setExcludeExtensions($this->config->coverage_exclude_extensions);
        
        return $cov;
    }

    /**
    */
    function coverDir($dir, $coverageReporter, $testReporter) {
        $this->loadEnvironment();

        $cov = $this->getCoverageRecorder($coverageReporter);

        $tests = $this->collector->getTests($dir);

        $group = new GroupTest('');
        foreach($tests as $test) {
            $group->addTestFile($test);
        }

        $cov->startInstrumentation();
        $group->run($testReporter);
        $cov->stopInstrumentation();
        
        $cov->generateReport();
    }

    /**
    */
    function coverFile($file, $coverageReporter, $testReporter) {
        $this->loadEnvironment();

        $cov = $this->getCoverageRecorder($coverageReporter);

        $group = new GroupTest('');
        $group->addTestFile($file);
        
        $cov->startInstrumentation();
        $group->run($testReporter);
        $cov->stopInstrumentation();
        
        $cov->generateReport();
    }

    /**
    */
    function runTestDir($dir, $reporter, $title) {
        $this->loadEnvironment();
        
        $tests = $this->collector->getTests($dir);

        $group = new GroupTest($title);
        foreach($tests as $test) {
            $group->addTestFile($test);
        }

        $group->run($reporter);
    }

    /**
    */
    function runTestFile($file, $reporter, $title) {
        $this->loadEnvironment();

        $group = new GroupTest($title);
        $group->addTestFile($file);

        $group->run($reporter);
    }
    
}

?>