<?php

class Wact_Test_Coverage_Recorder_TestCase extends Wact_Test_Case {

    function testisIncludedEmpty() {
        $recorder = new Wact_Test_Coverage_Recorder_Xdebug(array(), array(), null);
        $this->assertFalse($recorder->isIncluded('/var/www/any'));
    }

    function testIsIncluded() {
        $includePaths = array('/var/www/test', '/var/www/test2');
        $recorder = new Wact_Test_Coverage_Recorder_Xdebug($includePaths, array(), null);
        
        $this->assertTrue($recorder->isIncluded('/var/www/test'));
        $this->assertTrue($recorder->isIncluded('/var/www/test/'));
        $this->assertTrue($recorder->isIncluded('/var/www/test/sub'));

        $this->assertTrue($recorder->isIncluded('/var/www/test2'));
        $this->assertTrue($recorder->isIncluded('/var/www/test2/'));
        $this->assertTrue($recorder->isIncluded('/var/www/test2/sub'));

        /* fix this
        $this->assertFalse($recorder->isIncluded('/var/www/test3'));
        $this->assertFalse($recorder->isIncluded('/var/www/test3/'));
        $this->assertFalse($recorder->isIncluded('/var/www/test3/sub'));
        */
        
        $this->assertFalse($recorder->isIncluded('/var/www/t'));
        $this->assertFalse($recorder->isIncluded('/var/www/'));
    }
    
    function testIsExcludedExtension() {
        $recorder = new Wact_Test_Coverage_Recorder_Xdebug(array(), array(), null);
        
        $excludeExtensions = array('.test.php', '.test.inc.php');
        $recorder->setExcludeExtensions($excludeExtensions);
        
        $this->assertFalse($recorder->isExcludedExtension('a.php'));
        $this->assertTrue($recorder->isExcludedExtension('a.test.php'));
        $this->assertTrue($recorder->isExcludedExtension('a.test.inc.php'));
    }

    function skip() {
        $this->skipUnless(extension_loaded('xdebug'));
    }
    
}

?>
