<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* File level includes
*/
require_once SIMPLE_TEST . 'web_tester.php';

/**
* A Base test case class for web unit tests.
*/
abstract class Wact_Test_Case_Web extends WebTestCase {


    /**
    */
    public $testServerUrl = 'http://localhost';

    /**
    */
    function assertNormalPage() {
        $this->assertResponse(array(200));
        $this->assertNoUnwantedPattern('/Warning:/i');
        $this->assertNoUnwantedPattern('/Error:/i');
        $this->assertNoUnwantedPattern('/Fatal error/i');
    }

    /**
    */
    function assertWantedLiteral($str) {
        $this->assertWantedPattern('/' . preg_quote($str, '/').  '/');
    }

    /**
    */
    function assertNoUnWantedLiteral($str) {
        $this->assertNoUnWantedPattern('/' . preg_quote($str, '/').  '/');
    }

    /**
    */
    function _fileToPattern($file) {
        $file_as_array = file($file);
        $pattern = '#^';
        foreach ($file_as_array as $line) {
            /* strip trailing newline */
            if ($line[strlen($line) - 1] == "\n") {
                $line = substr($line, 0, strlen($line) - 1);
            }
            $line = preg_quote($line, '#');

            /* replace paths with wildcard */
            $line = preg_replace("#'/[^']*#", "'.*", $line);

            $pattern .= $line . '\n';
        }
        /* strip final newline */
        $pattern = substr($pattern, 0, strlen($pattern) - 2);
        $pattern .= '$#i';
        return $pattern;
    }

    /*
    * get an url from the test server.
    */
    function getTestServerUrl($path = '') {
        return $this->testServerUrl . $path;
    }

}

?>