<?php

class Wact_Template_Tag_wact_includeTestCase extends Wact_Test_Case {

    function setUp() {
        $this->reader = new Wact_Template_Reader_Transient();
        $this->cache = new Wact_Cache_Store_Transient();
        $this->loader = new Wact_Template_Loader($this->reader, $this->cache);

        $source = 'Terminal';
        $this->reader->writeSource('terminal.tpl.html', $source);

        $source = 'Nested-<wact:include file="terminal.tpl.html">-Nested';
        $this->reader->writeSource('nested.tpl.html', $source);
    }

    function testInclude() {
        $tmpl = $this->loader->load('nested.tpl.html');
        $output = $tmpl->capture();
        $this->assertEqual($output, 'Nested-Terminal-Nested');
    }

    function testIncludeMissingFile() {
        $source = '<wact:INCLUDE file="/cant/find/this/file/name/huh">';
        $this->reader->writeSource('missingfile.tpl.html', $source);

        try {
            $tmpl = $this->loader->load('missingfile.tpl.html');
            $this->fail('Expected exception not thrown');
        } catch (Wact_Template_Exception_Notfound $e) {
            $this->pass();
        }
    }

    function testMissingFileAttribute() {
        $source = 'Include-<wact:include>-Include';
        $this->reader->writeSource('missingfileattribute.tpl.html', $source);

        try {
            $tmpl = $this->loader->load('missingfileattribute.tpl.html');
            $this->fail('Expected exception not thrown');
        } catch (Wact_Template_Compiler_Exception_Missingattribute $e) {
            $this->pass();
        }
    }

    function testEmptyFileAttribute() {
        $source = 'Include-<wact:include file>-Include';
        $this->reader->writeSource('testemptyfileattribute.tpl.html', $source);

        try {
            $tmpl = $this->loader->load('testemptyfileattribute.tpl.html');
            $this->fail('Expected exception not thrown');
        } catch (Wact_Template_Compiler_Exception_Missingattribute $e) {
            $this->pass();
        }
    }

    function testNestedInclude() {
        $source = 'Include-<wact:include file="nested.tpl.html">-Include';
        $this->reader->writeSource('nestedinclude.tpl.html', $source);

        $tmpl = $this->loader->load('nestedinclude.tpl.html');
        $output = $tmpl->capture();
        $this->assertEqual($output, 'Include-Nested-Terminal-Nested-Include');
    }

    /*
    function testIncludeFileAttributeVariable() {
        $source = '<core:SET FILENAME="terminal.html"><wact:include file="{$FILENAME}">';
        $this->reader->writeSource('fileattributevariable.html', $source);

        $tmpl = $this->loader->load('fileattributevariable.html');
        $output = $tmpl->capture();
        $this->assertEqual($output, 'Terminal');
    }

    function testIncludedVariableReference() {
        $source = '{$Variable}';
        $this->reader->writeSource('varref.html', $source);

        $source = 'Include-<wact:include file="varref.html">-Include';
        $this->reader->writeSource('includedvarref.html', $source);

        $tmpl = $this->loader->load('includedvarref.html');
        $tmpl->set('Variable', 'Here');
        $output = $tmpl->capture();
        $this->assertEqual($output, 'Include-Here-Include');
    }
    */

    function testIncludeLiteral() {
        $literalSource = '{$Ref}<wact:block>{$Ref}</wact:block>';
        $this->reader->writeSource('literal.tpl.html', $literalSource);

        $source = '<wact:include file="literal.tpl.html" literal>';
        $this->reader->writeSource('includeliteral.tpl.html', $source);

        $tmpl = $this->loader->load('includeliteral.tpl.html');
        $output = $tmpl->capture();
        $this->assertEqual($output, $literalSource);
    }
}
?>