<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
 * Prevents a section of the template from being parsed, removing the contents
 * @tag wact:COMMENT
 */
class Wact_Template_Tag_wact_comment extends Wact_Template_Compiler_Node_Inline
{
    /**
    * @return void
    */
    public function checkNestingLevel() {
        if ($this->findParentByClass(__CLASS__)) {
            $this->raiseCompilerError('BADSELFNESTING');
        }
    }

    /**
    * @param Wact_Template_Compiler_Parser_TreeBuilder
    * @return int Wact_Template_Compiler_Node::FORBID_PARSING
    */
    public function preParse($treeBuilder) {
        return parent::FORBID_PARSING;
    }

    /**
    */
    function addChild($child) {
        // discard children
    }

}
?>