<?php

class Wact_Template_Tag_wact_blockTestCase extends Wact_Test_Case_Template {

    function setUp() {
        parent::setUp();

        $source = 'Before-<wact:block id="block">Block</wact:block>-After';
        $this->reader->writeSource('block.tpl.html', $source);

        $source = 'Before-<wact:block id="block" hide>Block</wact:block>-After';
        $this->reader->writeSource('hiddenblock.tpl.html', $source);
    }

    function testBlock() {
        $tmpl = $this->loader->load('block.tpl.html');

        $block = $tmpl->getChild('block');
        $this->assertTrue($block->IsVisible());
        $output = $tmpl->capture();
        $this->assertEqual($output, 'Before-Block-After');
    }

    function testHiddenBlock() {
        $tmpl = $this->loader->load('hiddenblock.tpl.html');

        $block = $tmpl->getChild('block');
        $this->assertFalse($block->IsVisible());
        $output = $tmpl->capture();
        $this->assertEqual($output, 'Before--After');
    }

    function testInvertBlock() {
        $tmpl = $this->loader->load('block.tpl.html');

        $block = $tmpl->getChild('block');
        $this->assertTrue($block->IsVisible());
        $block->hide();
        $this->assertFalse($block->IsVisible());
        $output = $tmpl->capture();
        $this->assertEqual($output, 'Before--After');
    }

    function testInvertHiddenBlock() {
        $tmpl = $this->loader->load('hiddenblock.tpl.html');

        $block = $tmpl->getChild('block');
        $this->assertFalse($block->IsVisible());
        $block->show();
        $this->assertTrue($block->IsVisible());
        $output = $tmpl->capture();
        $this->assertEqual($output, 'Before-Block-After');
    }

}
?>