<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* @formatter wordwrap
* @min_attributes 2
* @max_attributes 2
*/
class Wact_Template_Formatter_wordwrap extends Wact_Template_Compiler_Formatter {

    /**
    * Return this value as a PHP value
    * @return String
    */
    function getValue() {
        if ($this->isConstant()) {
            return wordwrap($this->parameters[0]->getValue(), $this->parameters[1]->getValue(), "\n", TRUE);
        } else {
            parent::getValue();
        }
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param CodeWriter
    * @return void
    */
    function generateExpression($code) {
        $code->writePHP('wordwrap(');
        $this->parameters[0]->generateExpression($code);
        $code->writePHP(',');
        $this->parameters[1]->generateExpression($code);
        $code->writePHP(', "\n", TRUE)');
    }

}

?>