<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* @formatter capitalize
*/
class Wact_Template_Formatter_capitalize extends Wact_Template_Compiler_Formatter {

    /**
    * Return this value as a PHP value
    * @return String
    */
    function getValue() {
        if ($this->isConstant()) {
            return ucfirst($this->parameters[0]->getValue());
        } else {
            parent::getValue();
        }
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param CodeWriter
    * @return void
    */
    function generateExpression($code) {
        $code->writePHP('ucfirst(');
        $this->parameters[0]->generateExpression($code);
        $code->writePHP(')');
    }

}

?>