<?php

class GoodHtml_TestCase extends Wact_Test_Case_Template {

    function testSelfClosingWactTagWithEndTagForbidden() {
        $tmpl = $this->createTempTemplate('<wact:placeholder Variable="Value" />');  // ENDTAG_FORBIDDEN

        $output = $tmpl->capture();
        $this->assertEqual($output, '');
    }

    function testSelfClosingHtmlTagWithEndTagForbidden() {
        $tmpl = $this->createTempTemplate('<img wact:id="foo" src="#"/>');  // ENDTAG_FORBIDDEN

        $output = $tmpl->capture();
        $this->assertEqual($output, '<img src="#"/>');
    }
    
    function testMinimizedAttributeOnViewTag() {
        $source = '<TAG wact:id="foo" CHECKED />';
        $tmpl = $this->createTempTemplate($source);

        $output = $tmpl->capture();
        $this->assertEqual($output, '<TAG CHECKED/>');
    }

    function testWhitespacePreserved() {
        $source = "<body>\n" . '{$test}' . "\n</body>";
        $tmpl = $this->createTempTemplate($source);
        $tmpl->setModel(array('test' => ''));
        
        $output = $tmpl->capture();
        $this->assertEqual($output, "<body>\n\n</body>");
    }

    function testXmlPreserved() {
        $source = <<<TEMPLATE
<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN'
      'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
  <head>

    <title>XML escapes</title>

  </head>
  <body>

    <!-- A comment -->

    <!--DOCTYPE as first string in comment -->

    <!-- a legal comment containing a <tag> and an &entity_reference; -->

    <script type="text/javascript" xml:space="preserve">
      <![CDATA[
      string = 'A CDATA block';
      ]]>
    </script>

    <h1>XML escapes</h1>

  </body>
</html>
TEMPLATE;
        $tmpl = $this->createTempTemplate($source);
        $tmpl->setModel(array('test' => ''));
        
        $output = $tmpl->capture();
        $this->assertEqual($output, $source);
    }

    function testJavascriptPreserved() {
        $source = <<<TEMPLATE
<script language="Javascript">
document.write('<B>Test<\/B>');
</script>
TEMPLATE;
        $tmpl = $this->createTempTemplate($source);
        $tmpl->setModel(array('test' => ''));
        
        $output = $tmpl->capture();
        $this->assertEqual($output, $source);
    }

    function testComplexJavascriptPreserved() {
        $source = <<<TEMPLATE
<script language="Javascript">
document.write('<A HREF="http://localhost/">Test<\/A>');
</script>
TEMPLATE;
        $tmpl = $this->createTempTemplate($source);
        $tmpl->setModel(array('test' => ''));
        
        $output = $tmpl->capture();
        $this->assertEqual($output, $source);
    }

    function testJavaScriptCommentEmbedPreserved() {
        $source = <<<TEMPLATE
<script language="Javascript">
<!--
document.write('<B>Test<\/B>');
//-->
</script>
TEMPLATE;
        $tmpl = $this->createTempTemplate($source);
        $tmpl->setModel(array('test' => ''));
        
        $output = $tmpl->capture();
        $this->assertEqual($output, $source);
    }

    function testComplexJavaScriptCommentEmbedPreserved() {
        $source = <<<TEMPLATE
<script language="Javascript">
<!--
document.write('<A HREF="http://localhost/>Test<\/A>');
//-->
</script>
TEMPLATE;
        $tmpl = $this->createTempTemplate($source);
        $tmpl->setModel(array('test' => ''));
        
        $output = $tmpl->capture();
        $this->assertEqual($output, $source);
    }

}

?>