<?php
class TemplateExpression_TestCase extends Wact_Test_Case_Template {

    function testIntegerConstant() {
        $tmpl = $this->createTempTemplate('{$23}');

        $output = $tmpl->capture();
        $this->assertEqual($output, '23');
    }

    function testFloatConstant() {
        $tmpl = $this->createTempTemplate('{$1.5}');

        $output = $tmpl->capture();
        $this->assertEqual($output, '1.5');
    }

    function testStringConstant() {
        $tmpl = $this->createTempTemplate('{$"hello"}');

        $output = $tmpl->capture();
        $this->assertEqual($output, 'hello');
    }

    function testDelimiterStringConstant() {
        $tmpl = $this->createTempTemplate('{$"}"}');

        $output = $tmpl->capture();
        $this->assertEqual($output, '}');
    }

    function testSingleQuoteStringConstant() {
        $tmpl = $this->createTempTemplate('{$"\'"!raw}');

        $output = $tmpl->capture();
        $this->assertEqual($output, '\'');
    }

    function testDoubleQuoteStringConstant() {
        $tmpl = $this->createTempTemplate('{$\'"\'!raw}');

        $output = $tmpl->capture();
        $this->assertEqual($output, '"');
    }

    function testPath() {
        $tmpl = $this->createTempTemplate('{$Data.Var}');

        $tmpl->setModel(array('Data' => array('Var' => 'test')));

        $output = $tmpl->capture();
        $this->assertEqual($output, 'test');
    }

    function testLongPath() {
        $tmpl = $this->createTempTemplate('{$Data.More.Var}');

        $tmpl->setModel(array('Data' =>  array('More' => array('Var' => 'test'))));

        $output = $tmpl->capture();
        $this->assertEqual($output, 'test');
    }

}
?>